#version 410 core
uniform sampler2D InputTexture;
uniform vec2 MaxUV;
uniform vec2 HardwareSize;

in vec2 uv;
out vec4 fragColor;

void main()
{

    vec4 color = vec4(0.0);
    float t = 0.005;
    
    float A = smoothstep(1.0, 1.0+t, uv.y + uv.x);
    float B = smoothstep(1.0-t, 1.0, uv.y + uv.x);
    
    color = vec4( B-A ); 
    
    float C = smoothstep(1.0, 1.0+t, uv.y + 1.0-uv.x * MaxUV.x);
    float D = smoothstep(1.0-t, 1.0, uv.y + 1.0-uv.x * MaxUV.x);
    
    
    float c = D-C + B-A;	
    fragColor = vec4(c, 0.0, 0.0, c/3.0*2.0);

}